<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Customer extends CI_Controller 
{

	public function index()
	{
		
	}
	
	
	
	/*
		YENI CARI KART
		@author: mustafa tanriverdi
		@description:
			* bu fonksiyon yeni bir tane cari kart oluşturur
	*/
	function add_customer()
	{
		$data['page_access'] = check_user_role('customer/add_customer');
		
		if(isset($_POST['btn_add_customer']) and check_refresh())
		{
			$this->form_validation->set_rules('code', 'Barkod Kodu', 'trim');
			$this->form_validation->set_rules('name', 'Cari Adı', 'trim|required|min_length[3]|max_lenght[32]');	
			
			if($this->form_validation->run() == true)
			{
				$post['code']	= mb_strtoupper($this->input->post('code'), 'utf-8');
				$post['name']	= mb_strtoupper($this->input->post('name'), 'utf-8');
				$post['phone']	= mb_strtoupper($this->input->post('phone'), 'utf-8');
				$post['gsm']	= mb_strtoupper($this->input->post('gsm'), 'utf-8');
				$post['email']	= mb_strtoupper($this->input->post('email'), 'utf-8');
				$post['address']= mb_strtoupper($this->input->post('address'), 'utf-8');
				$post['county'] = mb_strtoupper($this->input->post('county'), 'utf-8');
				$post['city']	= mb_strtoupper($this->input->post('city'), 'utf-8');
				$post['country']= mb_strtoupper($this->input->post('country'), 'utf-8');
				$post['vd']= mb_strtoupper($this->input->post('vd'), 'utf-8');
				$post['vno']= mb_strtoupper($this->input->post('vno'), 'utf-8');
				
				if(isset($_POST['check_code_active']) or $post['code'] == '') 
				{ 
					$post['code'] = karekterTemizle($post['name']);
				}
				else
				{
					$post['code'] = karekterTemizle($post['code']);	
				}
				
				
				$data['customer_id'] = $this->customer_model->add_customer($post);
					
				if($data['customer_id'] > 0)
				{
					$this->global_model->add_log(array(
					'type'			=> 'yeni',
					'customer_id'	=> $data['customer_id'],
					'text'			=> 'Yeni cari kart oluşturuldu.'
					));
					
					$data['alert_box']['type']	= 'success';
					$data['alert_box']['text']	= 'Cari kart oluşturuldu.';
					
					redirect(site_url('customer/the_customer/'.$data['customer_id']));
				}
				else
				{
					$data['alert_box']['type']	= 'alert';
					$data['alert_box']['text']	= 'Bilinmeyen bir hata oluştu.';	
				}
					
			}
		}
		
		$this->template->view('customer/add_customer_view', $data);
	}
	
	
	
	/*
		LİST CUSTOMER
		@author: mustafa tanriverdi
		@description: 
			* bu fonksiyon kayıtlı müşterleri listeler
	*/
	function list_customer()
	{
		$data['page_access'] = check_user_role('customer/list_customer');
		
		$data['customers'] = $this->customer_model->get_customer_list();
		
		$this->template->view('customer/list_customer_view', $data);
	}
	
	
	
	/*
		CUSTOMER
		@author: mustafa tanriverid
		@description: 
			* bu fonksiyon kayıtlı cariyi listeler
	*/
	function the_customer($customer_id)
	{
		$data['page_access'] = check_user_role('customer/the_customer');
		$continue = true;
		$data['customer_id'] = $customer_id;
		
		if(isset($_POST['btn_update_customer']))
		{
			$this->form_validation->set_rules('code', 'Barkod Kodu', 'trim');
			$this->form_validation->set_rules('name', 'Cari Adı', 'trim|required|min_length[3]|max_lenght[32]');	
			
			if($this->form_validation->run() == true)
			{
				$post['code']	= $this->input->post('code');
				$post['name']	= $this->input->post('name');
				$post['phone']	= $this->input->post('phone');
				$post['gsm']	= $this->input->post('gsm');
				$post['email']	= $this->input->post('email');
				$post['address']= $this->input->post('adress');
				$post['county'] = $this->input->post('county');
				$post['city']	= $this->input->post('city');
				$post['country']= $this->input->post('country');
				$post['vd']= $this->input->post('vd');
				$post['vno']= $this->input->post('vno');
				
				if($post['code'] == '' or isset($_POST['check_code_active'])) 
				{ 
					$post['code'] = karekterTemizle($post['name']);
					
					$this->db->from('customers');
					$this->db->where('code', $post['code']);
					$this->db->where_not_in('id', $data['customer_id']);
					$query = $this->db->get()->result_array();
					
					
				}
				else
				{
					$post['code'] = karekterTemizle($post['code']);
					
					$this->db->from('customers');
					$this->db->where('code', $post['code']);
					$this->db->where_not_in('id', $data['customer_id']);
					$query = $this->db->get()->result_array();
					
					if($query)
					{
						$continue = false;
						$data['alert_box']['type'] = 'alert';
						$data['alert_box']['text'] = 'Cari kodu veritabanında bulundu.';
					}
				}
				
				
				if($continue == true)
				{
					$post['customer_id'] = $data['customer_id'];
					$update = $this->customer_model->update_customer($post);
					
					if($update)
					{
						$this->global_model->add_log(array(
						'type'			=> 'yeni',
						'customer_id'	=> $data['customer_id'],
						'text'			=> 'Cari kart güncellendi.'
						));
						
						$data['alert_box']['type']	= 'success';
						$data['alert_box']['text']	= 'Cari kart güncellendi.';
					}
					else
					{
						$data['alert_box']['type']	= 'secondary';
						$data['alert_box']['text']	= 'Veritabanında herhangi bir veri güncellemesi gerçekleşmedi.';	
					}
				}
			}
		}
		
		
		# DELETE CUSTOMER
		if(isset($_GET['delete']))
		{
			$this->db->set('status', '1');
			$this->db->where('id', $customer_id);
			$this->db->update('customers');
			
			$this->global_model->add_log(array(
						'type'			=> 'sil',
						'customer_id'	=> $data['customer_id'],
						'text'			=> 'Cari kartı silindi.'
						));
		}
		# ACTIVE CUSTOMER
		if(isset($_GET['active']))
		{
			$this->db->set('status', '0');
			$this->db->where('id', $customer_id);
			$this->db->update('customers');
			
			$this->global_model->add_log(array(
						'type'			=> 'aktif',
						'customer_id'	=> $data['customer_id'],
						'text'			=> 'Cari kart aktif edildi.'
						));
		}
		
		$data['customer'] = $this->customer_model->get_customer($customer_id);
		
		$this->template->view('customer/customer_view', $data);
	}
	
	
}

