<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class User extends CI_Controller 
{

	/*
		ÜYE ÇIKIŞI
		@author: mustafa tanriverdi
		@description: bu fonksiyon giriş yapan bir üyenin siteden çıkmasını sağlamaktadır
	*/
	function log_out()
	{
		$this->session->unset_userdata('user_id');
		$this->session->unset_userdata('user_name');
		$this->session->unset_userdata('user_role');
		
		$this->load->view('user/logout_view');
	}
	
	
	
	/*
		TEKİL SAYFA
		@author: mustafa tanriverdi
		@description: bu fonksiyon tekil hata veya gösterim sayfaları içindir. 
			Eğer tek bir hata mesajı, uyarı mesajı yada vb. gibi durumlarda sayfa gösterimi için bu fonksiyonu kullanabilrisiniz.
	*/
	function single_page($key='')
	{
		if($key == 'giris_yapilmis')
		{
			$data['message'] = 'Üye girişi yapılmış. Bu panele erişemezsiniz';	
		}
		$this->load->view('user/single_page_view', $data);	
	}
	
	
	
	/*
		PROFİL SAYFASI
		@author: mustafa tanriverid
		@description: bu fonksiyon profilim sayfasını çalıştırmakta. 
	*/
	function profile($user_id='')
	{
		$data = array();
		$data['user_id'] = $user_id;
		
		if($user_id=='')
		{
			$user_real = true;
			$user_id = get_c_user('user_id');
			$data['user_id']		= get_c_user('user_id');
			$data['user_role_name'] = get_c_user('user_role_name');
			$data['user_role']		= get_c_user('user_role');
			$data['user_status']	= get_c_user('user_status');
			
			$data['user_name']		= get_c_user('user_name');
			$data['first_name']		= get_c_user('first_name');
			$data['last_name']		= get_c_user('last_name');
			$data['email']			= get_c_user('email');
			$data['gsm']			= get_c_user('gsm');
		}
		else
		{	
			$user_real = false;
			$user = $this->user_model->get_user($user_id);
			
			$data['user_id'] 		= $user_id;
			$data['user_role']		= $user['role'];
			$data['user_role_name'] = '';
				if($data['user_role'] == '1'){ $data['user_role_name'] = 'Süper Yönetici'; 		}
				else if($data['user_role'] == '2'){ $data['user_role_name'] = 'Yönetici'; 		}
				else if($data['user_role'] == '3'){ $data['user_role_name'] = 'Bölüm Amiri'; 		}
				else if($data['user_role'] == '4'){ $data['user_role_name'] = 'Yetkili Personel'; }
				else if($data['user_role'] == '5'){ $data['user_role_name'] = 'Personel'; }
			
			$data['user_status']	= $user['status'];
			
			$data['user_name']		= $user['user_name'];
			$data['first_name']		= $user['first_name'];
			$data['last_name']		= $user['last_name'];

		}
		
		
		/* -- şifre değiştirme -- */
		if(isset($_POST['btn_change_password']))
		{
			$this->form_validation->set_rules('new_password', 'Yeni Şifre', 'trim|required|min_length[6]|max_length[32]');
			$this->form_validation->set_rules('new_password_rep', 'Yeni Şifre Tekrar', 'trim|required|min_length[6]|max_length[32]');
			if($user_real) :
				$this->form_validation->set_rules('old_password', 'Güncel Şifre', 'trim|required|min_length[6]|max_length[32]');
			endif;
			
			if($this->form_validation->run() == TRUE)
			{
				$new_password		= $this->input->post('new_password');
				$new_password_rep	= $this->input->post('new_password_rep');
				if($user_real) :
					$old_password		= $this->input->post('old_password');
				endif;

				if($new_password == $new_password_rep)
				{
					if($user_real)
					{
						$this->db->from('users');
						$this->db->where('id', $user_id);
						$this->db->where('password', md5($old_password));
						$query = $this->db->get()->result_array();
					}
					else
					{
						$query = true;	
					}
					
					if($query)
					{
						$this->db->set('password', md5($new_password));	
						$this->db->where('id', $user_id);
						$this->db->update('users');
						
						echo $this->db->_error_message();
						
						if($this->db->affected_rows() > 0)
						{
							$data['alert_box']['type'] = 'success';
							$data['alert_box']['text'] = 'Şifre başarı ile değiştirildi';
						}
					}
					else
					{
						$data['alert_box']['type'] = 'alert';
						$data['alert_box']['text'] = 'Eski şifreni yanlış.';
					}
				}
				else
				{
					$data['alert_box']['type'] = 'alert';
					$data['alert_box']['text'] = 'Yeni şifreniz ile tekarar eden yeni şifreniz uyuşmuyor.';
				}
			}
		}
		/* /-- sifre degistirme -- */
		
		
		
		/* -- profil bilgilerini guncelle -- */
		if(isset($_POST['btn_update_form_profile']))
		{	
			$this->form_validation->set_rules('first_name', 'İsim', 'trim|required|min_length[3]|max_length[32]');
			$this->form_validation->set_rules('last_name', 'Soyisim', 'trim|required|min_length[3]|max_length[32]');
			if($this->form_validation->run() == TRUE)
			{
				$post['first_name']	= $this->input->post('first_name');
				$post['last_name']	= $this->input->post('last_name');
				
				$post['user_id']	= $user_id;
				$this->user_model->update_profile($post);
				
				$data['alert_box']['type'] = 'success';
				$data['alert_box']['text'] = 'Profil bilgileri güncellendi.';
				
			}
		}
		/* /-- profil bilgilerini guncelle -- */
		
		
		
		// kullanici silme
		if(isset($_POST['btn_delete']))
		{
			if(get_c_user('user_role') <= 2)
			{
				$this->db->set('status', 'delete');
				$this->db->where('id', $user_id);
				$this->db->update('users');
				
				$data['alert_box']['type'] = '';
				$data['alert_box']['text'] = 'Kullanıcı hesabı silindi.';
			}
		}
		
		$this->template->view('user/profile_view', $data);	
	}
	
	
	
	/*
		USER LIST
		@author: mustafa tanriverdi
		@description:
			* bu fonksiyon kayıtlı üyelerin listelerini göstermektedir
	*/
	function user_list()
	{	
		$data['user_list'] = $this->user_model->get_user_list();
		
		$this->template->view('user/list_user_view', $data);
	}
	
	
	
	/*
		YENI KULLANICI
		@author: mustafa tanriverdi
		@description:
			* yeni kullanıcı kaydı
	*/
	function new_user()
	{
		user_role(2);
		$data = array();
		
		if(isset($_POST['btn_new_user']) and check_refresh())
		{
			$this->form_validation->set_rules('user_name', 'Kullanıcı Adı', 'trim|required|min_length[6]|max_length[32]');
			$this->form_validation->set_rules('password', 'Şifre', 'trim|required|min_length[6]|max_length[32]');
			$this->form_validation->set_rules('role', 'Yetki', 'trim|required');
			$this->form_validation->set_rules('first_name', 'Ad', 'trim|required|min_length[3]|max_length[10]');
			$this->form_validation->set_rules('last_name', 'Soyad', 'trim|required|min_length[3]|max_length[10]');
			
			if($this->form_validation->run() == TRUE)
			{
				$post['user_name']	= $this->input->post('user_name');
				$post['password']	= $this->input->post('password');
				$post['role']		= $this->input->post('role');
				$post['first_name']	= $this->input->post('first_name');
				$post['last_name']	= $this->input->post('last_name');
				
				// kullanıcı adı kontrolü
				$this->db->from('users');
				$this->db->where('status', 'publish');
				$this->db->where('user_name', $post['user_name']);
				
				if($this->db->get()->result_array())
				{
					$data['alert_box']['type'] = 'alert';
					$data['alert_box']['text'] = 'Kullanıcı adı veritabanında bulundu. Başka bir kullanıcı adı deneyin.';
				}
				else
				{
					$user_id = $this->user_model->add_user($post);
					if($user_id > 0)
					{
						$data['alert_box']['type'] = 'success';
						$data['alert_box']['text'] = 'Kullanıcı hesabı oluşturuldu.';
						
						add_log(array(
								'type'			=> 'yeni',
								'user_id'		=> $user_id ,
								'text'			=> 'Kullanıcı hesabı oluşturdu.'
								));
					}
				}
			}
		}
		
		$this->template->view('user/new_user_view', $data);
	}
	
	
	/*
	SAYFA ERİŞİMİ YOK
	@author: mustafa tanriverdi
	@description: 
		* bu fonksiyon bir kulanının bir sayfay erişim yetkisi olmadığında çıkan uyarı ekranını göstermetkedir
	*/
	function no_access($role='')
	{
		$data['role'] = $role;
		$this->template->view('user/no_access_view', $data);
	}
	
	
	
}

