<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed'); ?>
<?php
/*
	KULLANICININ GİRİŞ YAPIP YAPILMADIĞI KONTROL ET
	@author: mustafa tanriverdi
	@description: 
		* Kullanıcının sisteme giriş yapıp yapılmadığını kontrol ediyor. 
		* Eğer kullanıcı sisteme giriş yapmamış ise kullanıcıyı giriş sayfasına yönlendiriyor.
		* Bu fonksiyonu istediğiniz her yerde kullanabilirsiniz. Bir fonksiyon başında ve ya bir sayfanın başına ekleyerek 
		sadece üyelerin erişmesini sağlayabilirsiniz.
*/
function check_user_login()
{
	$ci = & get_instance();
	if(!$ci->session->userdata('user_id'))
	{
		redirect(site_url('login/user_login'));	
	}
}




/*
	AKTİF KULLANICI BİLGİLERİ
	@author: mustafa tanriverdi
	@description:
		* Bu fonksiyon sisteme giriş yapan kullanıcının profil bilgilerini döndürmekte.
*/
function get_c_user($key)
{
	$ci = & get_instance();
	
	if($key == 'user_id'){ return $ci->session->userdata('user_id');		}
	if($key == 'id'){ return $ci->session->userdata('user_id');		}
	if($key == 'user_name'){ return $ci->session->userdata('user_name');	}
	if($key == 'user_role'){ return $ci->session->userdata('user_role');	}
	if($key == 'user_status'){ return $ci->session->userdata('user_status');	}
	if($key == 'user_role_name'){ 
		if($ci->session->userdata('user_role') == '1'){ return 'Süper Yönetici'; 		}
		else if($ci->session->userdata('user_role') == '2'){ return 'Yönetici'; 		}
		else if($ci->session->userdata('user_role') == '3'){ return 'Bölüm Amiri'; 		}
		else if($ci->session->userdata('user_role') == '4'){ return 'Yetkili Personel'; }
		else if($ci->session->userdata('user_role') == '5'){ return 'Personel'; }
	}
	
	# Profil Bilgileri
	if($key == 'first_name'){ return $ci->session->userdata('user_first_name'); }
	else if($key == 'last_name'){ return $ci->session->userdata('user_last_name'); }
	else if($key == 'email'){ return $ci->session->userdata('user_email'); }
	else if($key == 'gsm'){ return $ci->session->userdata('user_gsm'); }
	
	
}

function c_user($key)
{
	echo get_c_user($key);
}



/*
	KULLANICI YETKI KONTROLU
	@author: mustafa tanriverdi
	@description:
		* bu fonksiyon bir kullanıcnın yetkisini kontrol ederek, sayfaya erşip erişemiyeceğini kontrol eder.
*/
function user_role($role, $data='')
{
	if($role == 'admin') { $role = '1'; }
	else if($role == 'administrator') { $role = '1'; }
	else if($role == 'superadmin') { $role = '1'; }
	
	
	if(get_c_user('user_role') <= $role){}
	else {
		redirect(site_url('user/no_access/'.$role));	
	}
}





function get_user_meta($user_id, $meta_key, $data='')
{	
	$ci = & get_instance();
	
	$ci->db->from('user_meta');
	$ci->db->where('user_id', $user_id);
	$ci->db->where('meta_key', $meta_key);
	$query = $ci->db->get()->result_array();
	
	return $query[0]['meta_value'];
}



/* -- USER ROLE TEXT -- */
function get_role_text($role)
{
	if($role == '1'){ return 'Süper Yönetici'; 		}
	else if($role == '2'){ return 'Yönetici'; 		}
	else if($role == '3'){ return 'Bölüm Amiri'; 		}
	else if($role == '4'){ return 'Yetkili Personel'; }
	else if($role == '5'){ return 'Personel'; }	
}

function role_text($role)
{
	echo get_role_text($role);	
}




?>