<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Fiche_Model extends CI_Model 
{
	
	public function index()
	{
		
	}
	
	
	
	/*
		SIPARIS EKLEME
		@author: mustafa tanriverdi
		@description:
			* bu fonksiyon yeni bir sipariş fişi oluştur
	*/
	function add_order($data)
	{
		$values = array(
					'date'			=> $data['date'],
					'type'			=> $data['type'],
					'customer_id'	=> $data['customer_id'],
					'tax_status'	=> $data['tax_status']
					);
		$this->db->insert('fiches', $values);
		return $this->db->insert_id();
	}
	
	
	
	/*
		SIPARIS META
		@author: mustafa tanriverdi
		@description:
			* bu fonksiyon yeni bir meta bilgisi ekler
	*/
	function add_order_meta($order_id, $meta_key, $meta_value, $meta_other='')
	{
		$values = array(
					'fiche_id'		=> $order_id,
					'meta_key'		=> $meta_key,
					'meta_value'	=> $meta_value,
					'meta_other'	=> $meta_other
					);	
		
		$this->db->insert('fiche_meta', $values);
		return $this->db->insert_id();
	}
	
	
	
	/*
		GET ORDER
		@author: mustafa tanriverdi
		@description:
			* bu fonksiyon sipariş bilgilerini döndürmektedir
	*/
	function get_order($order_id)
	{
		$this->db->from('fiches');
		$this->db->where('id', $order_id);
		$query = $this->db->get()->result_array();
		
		if($query)
		{
			return $query[0];	
		}
		else
		{
			return false;	
		}
	}
	
	
	
	/*
		GET ORDER META
		@author: mustafa tanriverdi
		@description:
			* bu fonksiyon meta bilgilerini döndürür
	*/
	function get_order_meta($order_id, $data='')
	{
		$this->db->from('fiche_meta');
		$this->db->where('fiche_id', $order_id);
		$query = $this->db->get()->result_array();	
		
		if($query)
		{ 
			foreach($query as $o_metas)
			{
				$order_meta[$o_metas['meta_key']] = $o_metas['meta_value']; 	
			}
			
			return $order_meta;
		} 
		else { return false; }
	}
	
	
	
	
	/*
		ORDER ITEMS
		@author: mustafa tanriverdi
		@description:
			* bu fonksiyon kayıtlı bir fişe yeni bir ürün ekler
	*/
	function add_order_item($data)
	{
		$values = array(
					'date'			=> get_date(true),
					'type'			=> $data['type'],
					'fiche_id' 		=> $data['fiche_id'],
					'customer_id'	=> $data['customer_id'],
					'product_id'	=> $data['product_id'],
					'amount'		=> $data['amount'],
					'purchase_price'=> $data['purchase_price'],
					'sale_price'	=> $data['sale_price'],
					'price'			=> $data['price'],
					'total'			=> $data['total'],
					'tax_rate'		=> $data['tax_rate'],
					'tax'			=> $data['tax'],
					'grand_total'	=> $data['grand_total'],
					'approved_date'	=> $data['approved_date'],
					'user_id'		=> $data['user_id']
					);
		$this->db->insert('fiche_items', $values);
		return $this->db->insert_id();
	}
	
	
	
	/*
		GET FICHE ITEM
	*/
	function get_fiche_item($fiche_item_id)
	{
		$this->db->from('fiche_items');
		$this->db->where('id', $fiche_item_id);
		
		$item = $this->db->get()->result_array();
		
		if($item)
		{
			return $item[0];
		}
		else
		{
			return false;	
		}
	}
	
	
	function get_fiche_app_item($fiche_item_id)
	{
		$this->db->from('fiche_items');
		$this->db->where('fiche_id', $fiche_item_id);
		
		$item = $this->db->get()->result_array();
		
		if($item)
		{
			return $item[0];
		}
		else
		{
			return false;	
		}
	}
	/*
		GET ORDER ITEMS
		@author: mustafa tanriverdi
		@description:
			* bu fonksiyon fişe bağlı hareketleri listeler
	*/
	function get_fiche_items($order_id)
	{
		$this->db->from('fiche_items');
		$this->db->where('status', '0');
		$this->db->where('fiche_id', $order_id);
		
		$items = $this->db->get()->result_array();
		
		if($items)
		{
			return $items;
		}
		else
		{
			return false;	
		}
	}
	
	
	
	
	/*
		DELETE FICHE ITEM
		@authro: mustafa tanriverdi
		@description
			* bu fonksiyon belirtilen ID'deki hareketi siler
	*/
	function delete_fiche_item($fiche_item_id)
	{
		$this->db->where('id', $fiche_item_id);
		$this->db->update('fiche_items', array('status'=>'1', 'amount'=>'0'));
		
		if($this->db->affected_rows() > 0)
		{
			return true;	
		}
		else
		{
			return false;	
		}
	}
	
	
	
	
}

