<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Product_Model extends CI_Model 
{
	/*
		PRODUCT MODEL
		@author: mustafa tanriverdi, [array]
		@description:
			* Merhabalar, ben mustafa tanriverdi bu model dosyası aslında stok kartı dosyasını temsil etmektedir. 
			* İngilizce "product" kelimesinin karşılığı "ürün/malzeme" anlamına gelmektedir. 
	*/
	
	public function index()
	{
		
	}
	
	
	
	/*
		ADD PRODUCT
		@author: mustafa tanriverdi
		@description:
			* Bu fonksiyon ürün ekleme işlemini gerçekleştirir
	*/
	function add_product($data)
	{
		$values	= array(
					'code'	=> $data['code'],
					'name'	=> $data['name'],
					'purchase_price' => $data['purchase_price'],
					'sale_price' => $data['sale_price'],
					'tax_rate' => $data['tax_rate']
					);
		
		$this->db->insert('products', $values);
		return $this->db->insert_id();
	}
	
	
	
	/*
		GET PRODUCT
		@author: mustafa tanriverdi
		@description:
			* Bu fonksiyon kayıtlı bir ürün kartını döndürmekte
	*/
	function get_product($product_id, $data='')
	{
		$this->db->from('products');
		if($product_id != '') { $this->db->where('id', $product_id); }
		else {  $this->db->where($data); }
		$query = $this->db->get()->result_array();

		if($query)
		{
			return $query[0];	
		}
		else
		{
			return false;	
		}
	}
	
	
	
	/*
		GET PRODUCT LIST
		@author: mustafa tanriverdi
		@description:
			* bu fonksiyon kayıtlı ürünleri listeler
	*/
	function get_list_product()
	{
		$this->db->from('products');
		$this->db->where('status', '0');
		$query = $this->db->get()->result_array();
		
		if($query)
		{
			return $query;	
		}
		else
		{
			return false;
		}
			
	}
	
	
	
	/*
		UPDATE PRODUCT
		@author: mustafa tanriverdi
		@description:
			* Bu fonksiyon ürün güncelleme işlemini gerçekleştirir
	*/
	function update_product($data)
	{
		$values	= array(
					'code'				=> $data['code'],
					'name'				=> $data['name'],
					'purchase_price' 	=> $data['purchase_price'],
					'sale_price' 		=> $data['sale_price'],
					'tax_rate'			=> $data['tax_rate']
					);
		
		$this->db->where('id', $data['product_id']);
		$this->db->update('products', $values);
		return $this->db->affected_rows();
	}
	
	
	
	/*
		DELETE PRODUCT
		@author: mustafa tanriverdi
		@description:
			* bu fonksiyon ürün kartını silmektedir		
	*/
	function delete_product($product_id)
	{
		$this->db->set('status', '1');
		$this->db->where('id', $product_id);
		$this->db->update('products');
		
		return $this->db->affected_rows();	
	}
	
	
	
	/*
		ACTIVE PRODUCT
		@author: mustafa tanriverdi
		@description:
			* bu fonksiyon ürün kartını aktif etmektedir		
	*/
	function active_product($product_id)
	{
		$this->db->set('status', '0');
		$this->db->where('id', $product_id);
		$this->db->update('products');
		
		return $this->db->affected_rows();	
	}
	
	
	
}

