<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class User_Model extends CI_Model 
{

	
	public function index()
	{
		
	}
	
	
	
	/*
		KULLANICI BİLGİSİ
		@author: mustafa tanriverdi
		@description: 
			* bu fonksiyon kullanıcı bilgilerini veritabanıdnan çekmetktedir
	*/
	function get_user($user_id)
	{
		$this->db->from('users');
		$this->db->where('id', $user_id);
		
		$query = $this->db->get()->result_array();
		
		return $query[0];
	}
	
	
	
	/*
		GET USER META
		@author: mustafa tanriverdi
		@description: 
			* bu fonksiyon user_meta tablosunda user bilgilerni döndürmekte
	*/
	function get_user_meta($data)
	{
		$user_id	= $data['user_id'];
		
		$this->db->from('user_meta');
		$this->db->where('user_id', $user_id);
		$query = $this->db->get()->result_array();
		
		$meta = array();
		foreach($query as $q)
		{
			$meta[$q['meta_key']] = $q['meta_value']; 
		}
		
		return $meta;
	}
	
	
	
	/*
		PROFIL BILGILERI GUNCELLEME
		@author: mustafa tanriverdi
		@description:
			* bu fonksiyon profil bilgilerini günceller. Eğer profil bilgileri hiç oluşmamış ise oluşturur.
			* ad, soyad, e-posta, cep telefonu gibi user_meta bilgilerini günceller
			* eğer herhangi bir data bulamaz ise oluşturur.
	*/
	function update_profile($data)
	{
		
		$this->db->where('id', $data['user_id']);
		$this->db->update('users', array('first_name'=>$data['first_name'], 'last_name'=>$data['last_name']));
		
		$this->session->set_userdata('user_first_name', $data['first_name']);
		$this->session->set_userdata('user_last_name', $data['last_name']);
		
	}
	
	
	
	/*
		KULLANICI EKLE
		@author: mustafa tanriverdi
		@description:
			* yeni bir kullanıcı ekler
			* eklenen kullanının profil(user_meta) bilgilerini ekler
	*/
	function add_user($data)
	{	
		$values = array(
					'user_name'	=> $data['user_name'],
					'password'  => md5($data['password']),	
					'role'		=> $data['role'],
					'first_name'		=> $data['first_name'],
					'last_name'			=> $data['last_name']
				);
		$this->db->insert('users', $values);
		$user_id = $this->db->insert_id();
		
		
		if($user_id > 0)
		{
			$data['user_id'] = $user_id;
			$this->update_profile($data);
		}
		
		return $user_id;
	}
	
	
	
	/*
		KULLANICI LİSTESİ
		@author: mustafa tanriverdi
		@description:
			* bu fonksiyon kayıtlı kullanıcıları listeler
	*/
	function get_user_list($data='')
	{
		$this->db->from('users');
		$this->db->where('status', 'publish');
		return $query = $this->db->get()->result_array();
		
	}
}

