<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class General extends CI_Controller 
{

	public function index()
	{
		
	}
	
	
	
	
	/*
		PRINT BARCODE
		@author: mustafa tanriverid
		@description:
			* bu fonksiyon barkod kodunu ekrena basar istenen sonunca göre yazdırma penceresini açar
	*/
	function print_barcode($print_code, $print='')
	{
		echo '<img src="'.base_url('theme/javascripts/class/barcode/barcode.php?barcode='.$print_code).'" />';
	
		if($print == 'print')
		{
			$task = 'window.print(); parent.close(); ';	
			echo '<body onLoad="'.$task.'">';
		}
	}
	
	
	
	/*
		ADD MESSAGE
		@author: mustafa tanriverdi
		@description:
			* bu fonksiyon yeni mesaj gönderir
	*/
	function new_message()
	{
		$data['page_access'] = check_user_role('general/new_message');
		
		if(isset($_POST['btn_new_message']) and check_refresh())
		{
			$this->form_validation->set_rules('user_id', 'Kullanıcı Kartı', 'trim|required|numeric|min_length[1]|max_length[11]');	
			$this->form_validation->set_rules('subject', 'Konu', 'trim|required|min_length[3]|[max_length[50]');
			$this->form_validation->set_rules('message', 'Mesaj', 'required|min_length[1]|max_length[5000]');
			
			if($this->form_validation->run() == TRUE)
			{
				$post['sender_user_id']		= get_c_user('id');
				$post['receiver_user_id'] 	= $this->input->post('user_id');
				$post['subject'] = $this->input->post('subject');
				$post['message'] = $this->input->post('message');
				
				if($this->general_model->new_message($post))
				{
					$data['alert_box']['type']	= 'success';
					$data['alert_box']['text']	= 'Yeni mesaj gönderildi.';
				}
			}
		}
		
		
		$this->template->view('user/new_message_view', $data);	
	}
	
	
	
	/*
		MESAJ KUTUSU
		@author: mustafa tanriverdi
		@description:
			* bu fonksiyon mesaj kutusunu gösterir
			* aldığı parametreye göre gelen, giden ve arşiv klasörlerini gösterir	
	*/
	function message_box($box_type)
	{
		$data = array();

		$data['message_list'] = $this->general_model->message_list_box(array('box_type'=>$box_type));
			
		$this->template->view('user/message_box_view', $data);
	}
	
	
	
	/*
		SHOW MESSAGE
		@author: mustafa tanriverdi
		@description:
			* bu fonksiyon bir mesajı gösterir
	*/
	function message_show($message_id)
	{
		$data = array();
		
		$data['message'] = $this->general_model->get_message($message_id);
		
		// eğer top mesaj var ise yönlendir
		if($data['message']['top_id'] > 0)
		{
			redirect(site_url('general/message_show/'.$data['message']['top_id'].'/?'));	
		}
		
		// mesaj yetki kontrolü
		if($data['message']['sender_user_id'] == get_c_user('id')){}
		else if($data['message']['receiver_user_id'] == get_c_user('id')){}
		else if(get_c_user('id') <= 2){}
		else
		{
			show_error('Bu mesajı okumaya yetkiniz yok.');	
		}
		
		
		// CEVAP MESAJI EKLEME
		if(isset($_POST['btn_reply']) and check_refresh())
		{
			$this->form_validation->set_rules('reply_message', 'Cevap Mesajı', 'trim|required|min_length[3]|max_length[5000]');
			
			if($this->form_validation->run() == TRUE)
			{
				if($data['message']['sender_user_id'] == get_c_user('id'))
				{
					$post['sender_user_id']		= get_c_user('id');
					$post['receiver_user_id'] 	= $data['message']['receiver_user_id'];
				}
				else
				{
					$post['sender_user_id']		= get_c_user('id');
					$post['receiver_user_id'] 	= $data['message']['sender_user_id'];
				}
				
				$post['subject'] = $data['message']['subject'];
				$post['message'] = $this->input->post('reply_message');
				$post['top_id']  = $data['message']['id'];
				
				if($this->general_model->new_message($post))
				{	
					$data['alert_box']['type']	= 'success';
					$data['alert_box']['text']	= 'Mesaj gönderildi.';
				}
			}
		}
		
		
		// CEVAP MESAJLARINI SİLME
		if(isset($_GET['delete_reply_message_id']))
		{
			$delete_reply_message_id = $_GET['delete_reply_message_id'];
			$this->db->where('id',$delete_reply_message_id);
			$this->db->update('user_msg', array('status'=>'1'));
			
			$data['alert_box']['type']	= '';
			$data['alert_box']['text']	= 'Mesaj silindi.';
			
			add_log(array(
								'type'			=> 'sil',
								'user_id'		=> get_c_user('id'),
								'text'			=> 'Mesaj silindi. ['.$delete_reply_message_id.']'
								));
		}
		
		
		// ANA MESAJI ARŞİVE TAŞI
		if(isset($_GET['move_archive_message_id']))
		{
			$move_archive_message_id = $_GET['move_archive_message_id'];
			$this->db->where('id',$move_archive_message_id);
			$this->db->update('user_msg', array('archive'=>'1'));
			
			$data['alert_box']['type']	= 'success';
			$data['alert_box']['text']	= 'Mesaj arşive taşındı.';
			
			add_log(array(
								'type'			=> 'taşı',
								'user_id'		=> get_c_user('id'),
								'text'			=> 'Mesaj arşive taşındı. ['.$move_archive_message_id.']'
								));
		}
		
		// ANA MESAJI ARŞİVDEN GERİ NORMAL MESAJLARA TAŞI
		if(isset($_GET['move_box_message_id']))
		{
			$move_box_message_id = $_GET['move_box_message_id'];
			$this->db->where('id',$move_box_message_id);
			$this->db->update('user_msg', array('archive'=>'0'));
			
			$data['alert_box']['type']	= 'success';
			$data['alert_box']['text']	= 'Mesaj arşivden çıkartıldı.';
			
			add_log(array(
								'type'			=> 'taşı',
								'user_id'		=> get_c_user('id'),
								'text'			=> 'Mesaj arşivden çıkartıldı. ['.$move_box_message_id.']'
								));
		}
		
		// okuma bilgisini güncelle
		if($data['message']['receiver_user_id'] == get_c_user('id')) :
			$this->db->where('id', $message_id);
			$this->db->update('user_msg', array('read_status'=>'read', 'read_date'=>get_date()));
		endif; 
		
		
		$data['message'] = $this->general_model->get_message($message_id);
		
		$this->template->view('user/message_show_view', $data);	
	}
	
	
	
}

