<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Order extends CI_Controller 
{

	public function index()
	{
		
	}
	
	
	
	/*
		ADD ORDER
		@author: mustafa tanriverdi
		@description:
			* bu fonksiyon yeni bir tane stok kartı oluşturur
	*/
	public function add_order()
	{
		$data['page_access'] = check_user_role('order/add_order');
		
		if(isset($_POST['btn_add_order']) and check_refresh())
		{
			$this->form_validation->set_rules('customer_id', 'Müşteri Kodu', 'trim|required');	
			$this->form_validation->set_rules('date', 'Tarih', 'trim|required');
			
			if($this->form_validation->run() == true)
			{
				$post['customer_id'] = $this->input->post('customer_id');
				$post['date']		 = $this->input->post('date');
				$post['note']		 = $this->input->post('note');
				$post['type']		 = $this->input->post('type');
				
				if(isset($_POST['tax_status'])) { $post['tax_status'] = 0; } else { $post['tax_status'] = 1; }
				
				$order_id = $this->fiche_model->add_order($post);
				
				if($order_id > 0)
				{
					$this->fiche_model->add_order_meta($order_id, 'note', $post['note']);
					
					$this->db->where('id', $order_id);
					$this->db->update('fiches', array('payment_type'=>'KAPIDANAKIT', 'ship_type'=>'KARGO'));
					
					add_log(array(
								'type'			=> 'yeni fiş',
								'customer_id'	=> $post['customer_id'],
								'fiche_id'		=> $order_id,
								'text'			=> 'Yeni fiş oluşturuldu.'
								));
					
					$data['alert_box']['type']	= 'success';
					$data['alert_box']['text']	= 'Sipariş fişi oluşturuldu.';
					
					redirect(site_url('order/order_item/'.$order_id.'/'));
				}
				else
				{
					$data['alert_box']['type']	= 'alert';
					$data['alert_box']['text']	= 'Bilinmeyen bir hata oluştu.';	
				}
			}
		}
		
		$data['customers'] = $this->customer_model->get_customer_list();
		
		$this->template->view('order/add_order_view', $data);
	}
	
	
	
	
	
	/*
		ORDER ITEM
		@author: mustafa tanriverdi
		@description:
			* bu fonksiyon fişe ürün ekler, düzenler, siler vb. işlemleri gerçekleştirir
	*/
	function order_item($order_id)
	{
		$data['page_access'] = check_user_role('order/order_item');
		
		$data['fiche'] = $this->fiche_model->get_order($order_id);
		
		// fiş türü kontrol edelim eğer ödeme fişi ise yönelendirelim
		if($data['fiche']['leaf'] == 'pay') { redirect(site_url('payment/the_payment/'.$data['fiche']['id'].'/?')); }
		
		// YENI ÜRÜN EKLEME
		if(isset($_POST['product_code']) and check_refresh())
		{
			$this->form_validation->set_rules('product_code', 'Ürün Kodu', 'trim|required|min_length[3]|max_length[50]');
			$this->form_validation->set_rules('product_amount', 'Adet', 'trim|required|min_length[1]|max_length[11]');
			$this->form_validation->set_rules('one_price', 'Birim Fiyat', 'trim|required|min_length[1]|max_length[11]|numeric');
			
			if($this->form_validation->run() == true)
			{
				$product_code	= $this->input->post('product_code');
				$amount			= $this->input->post('product_amount');
				$price			= $this->input->post('one_price');
				
				// ürün kodunun veritabanında olup olmadığını kontrol edelim
				$this->db->from('products');
				$this->db->where('code', $product_code);
				$this->db->where('status', '0');
				$query = $this->db->get()->result_array();
				if($query)
				{
					// Ürün kartı ek bilgiler	
					$product = $query[0];
					$insert_data['product_id']		= $product['id'];
					$insert_data['purchase_price']	= $product['purchase_price'];
					$insert_data['sale_price'] 		= $product['sale_price'];
					$insert_data['approved_date'] 		= $this->input->post('approved_date');
					
					// eğer ürün fiyatı boş ise güncel fiyatlar ile eşlendiriliyor
					if($price < 0.01)
					{
						if($data['fiche']['type'] == 0) :
							$price = $insert_data['sale_price'];
						else : 
							$price = $insert_data['purchase_price'];
						endif;	
					}
					
					// kdv oranları hesaplanıyor
					$insert_data['total']	= $amount * $price;
					if($data['fiche']['tax_status'] == '0') :
						$insert_data['tax']			= ($insert_data['total'] / 100) * $product['tax_rate'];
						$insert_data['tax_rate']	= $product['tax_rate'];
					else :
						$insert_data['tax']			= 0.00;
						$insert_data['tax_rate']	= 0.00;
					endif;
					$insert_data['grand_total'] = $insert_data['total'] + $insert_data['tax'];
					
					
					$insert_data['type']		= $data['fiche']['type'];
					$insert_data['price'] 		= $price;
					$insert_data['amount']		= $amount;
					$insert_data['fiche_id'] 	= $order_id; 
					$insert_data['customer_id']	= $data['fiche']['customer_id'];
					
					$insert_data['user_id']		= get_c_user('user_id');
					
					// ürün ekleme işlemni model dosyasına gönder
					$order_item_id = $this->fiche_model->add_order_item($insert_data);
					
					
					// eğer fişe ürün ekleme başarılı ise
					if($order_item_id > 0)
					{	
						
						check_product_card($insert_data['product_id']);
						
						add_log(array(
								'type'			=> 'ekleme',
								'customer_id'	=> $data['fiche']['customer_id'],
								'product_id'	=> $insert_data['product_id'],
								'fiche_id'		=> $data['fiche']['id'],
								'text'			=> 'Hareket eklendi.'
								));
								
						$data['alert_box']['type']	= 'success';
						$data['alert_box']['text']	= 'Ürün ekleme işlemi başarılı.';
					}
					else // eğer fişe ürün ekleme başarısız ise
					{
						$data['alert_box']['type']	= 'alert';
						$data['alert_box']['text']	= 'Ürün eklenirken bilinmeyen bir hata meydana geldi.';
					}
				}
				else // eğer ürün kodu veritabanında bulunmadıysa
				{
					$data['alert_box']['type']	= 'alert';
					$data['alert_box']['text']	= 'Ürün kodu veritabanında bulunamadı.';	
				}
			}
		}
		
		
		
		// ÜRÜN SİLME
		if(isset($_GET['delete_item_id']))
		{
			$delete_item_id = $_GET['delete_item_id'];
			
			if($this->fiche_model->delete_fiche_item($delete_item_id))
			{
				$get_item = $this->fiche_model->get_fiche_item($delete_item_id);
				add_log(array(
							'type'			=> 'sil',
							'customer_id'	=> $data['fiche']['customer_id'],
							'product_id'	=> $get_item['product_id'],
							'fiche_id'		=> $data['fiche']['id'],
							'text'			=> 'Hareket silindi.'
							));
								
				check_product_card($get_item['product_id']);
								
				$data['alert_box']['type']	= '';
				$data['alert_box']['text']	= 'Fiş hareketleri silindi ve veriler güncellendi.';	
			}
		}
		
		
		check_order($data['fiche']['id']); // fiş bakiyesini derle
		check_customer_card($data['fiche']['customer_id']); // cari bakiyesini derle
		
		// son fiş bilgilerini döndür
		$data['fiche'] = $this->fiche_model->get_order($order_id);
		
		if($data['fiche']['type'] == '0') : $price='sale_price'; else : $price='purchase_price'; endif;
		$data['products_card_list'] = $this->load->view('product/_product_card_list_view', array('code'=>'#product_code', $price=>'#one_price'), TRUE);
		
		
		$this->template->view('order/order_item_view', $data);
	}
	
	
	
	
	/*
		FICHE LIST
		@author: mustafa tanrıverdi
		@description:
			* bu fonksiyon kayıtlı fişleri listeler
	*/
	function get_fiche_list()
	{
		$where['page_access'] = check_user_role('order/get_fiche_list');	
		
		$where['where'] = array('status'=>'0', 'leaf'=>NULL);
		$where['order_by'] = 'id'; $where['order_by_value']='DESC';
		$where['title'] = 'HAREKET FİŞLERİ';
		$this->template->view('fiche/_fiche_list_view', $where);
	}
	
	
	
	/*
		POST ADD ORDER
		@author: mustafa tanrıverdi
		@description:
			* bu fonksiyon dış sitelerden gelen siparişleri otomatik oluşturur
	*/
	function post_add_order()
	{
		
		// güvenlik için 1 İp adresi en fazla 5 sipariş verebilir
		$this->db->from('fiches');
		$this->db->where('date >', date("Y-m-d"));
		$this->db->where('ip', $_POST['ip']);
		$query = $this->db->get(); 
		echo $query->num_rows();
		if($query->num_rows() > 25)
		{
			$this->load->library('email');

			$this->email->from('tanriverdi.ms@gmail.com', 'TilPark!');
			$this->email->to('tanriverdi.ms@gmail.com'); 
			$this->email->cc('tanriverdi.ms@gmail.com'); 
			$this->email->bcc('tanriverdi.ms@gmail.com'); 
			
			$this->email->subject('Spam Saldırısı');
			$this->email->message(' Spam Saldırısı'.$_POST['ip'].' ['.$query->num_rows().'] ');	
			
			$this->email->send();
			
			exit('<script>alert("Spam şüphesi ile sipariş oluşturulmadı!");</script>');	
		}
		
		
		$data = array();
		$this->form_validation->set_rules('name', 'Müşteri Adı', 'trim|required|min_length[3]|max_length[36]');	
		$this->form_validation->set_rules('gsm', 'Telefon', 'trim|required|min_length[10]|max_length[11]|digits');
		$this->form_validation->set_rules('address', 'Adres', 'trim|required|min_length[15]|max_length[500]');	
		
		if($this->form_validation->run() == true)
		{
			/* YENI CARI KART OLUSTURME */
			$post['code']	= mb_strtoupper($this->input->post('code'), 'utf-8');
			$post['name']	= mb_strtoupper($this->input->post('name'), 'utf-8');
			$post['phone']	= mb_strtoupper($this->input->post('phone'), 'utf-8');
			$post['gsm']	= mb_strtoupper($this->input->post('gsm'), 'utf-8');
			$post['email']	= mb_strtoupper($this->input->post('email'), 'utf-8');
			$post['address']= mb_strtoupper($this->input->post('address'), 'utf-8');
			$post['county'] = mb_strtoupper($this->input->post('county'), 'utf-8');
			$post['city']	= mb_strtoupper($this->input->post('city'), 'utf-8');
			$post['country']= mb_strtoupper($this->input->post('country'), 'utf-8');
			
			if($post['city'] == '01')		{	$post['city'] = 'ADANA';		}
			else if($post['city'] == '02')	{	$post['city'] = 'ADIYAMAN';		}
			else if($post['city'] == '03')	{	$post['city'] = 'AFYON';		}
			else if($post['city'] == '04')	{	$post['city'] = 'AĞRI';			}
			else if($post['city'] == '05')	{	$post['city'] = 'AMASYA';		}
			else if($post['city'] == '06')	{	$post['city'] = 'ANKARA';		}
			else if($post['city'] == '07')	{	$post['city'] = 'ANTALYA';		}
			else if($post['city'] == '08')	{	$post['city'] = 'ARTVIN';		}
			else if($post['city'] == '09')	{	$post['city'] = 'AYDIN';		}
			else if($post['city'] == '10')	{	$post['city'] = 'BALIKESIR';	}
			else if($post['city'] == '11')	{	$post['city'] = 'BİLECEK';		}
			else if($post['city'] == '12')	{	$post['city'] = 'BINGOL';		}
			else if($post['city'] == '13')	{	$post['city'] = 'BITLIS';		}
			else if($post['city'] == '14')	{	$post['city'] = 'BOLU';			}
			else if($post['city'] == '15')	{	$post['city'] = 'BURDUR';		}
			else if($post['city'] == '16')	{	$post['city'] = 'BURSA';		}
			else if($post['city'] == '17')	{	$post['city'] = 'ÇANAKKALE';	}
			else if($post['city'] == '18')	{	$post['city'] = 'ÇANKIRI';		}
			else if($post['city'] == '19')	{	$post['city'] = 'ÇORUM';		}
			else if($post['city'] == '20')	{	$post['city'] = 'DENIZLI';		}
			else if($post['city'] == '21')	{	$post['city'] = 'DIYARBAKIR';	}
			else if($post['city'] == '22')	{	$post['city'] = 'EDIRNE';		}
			else if($post['city'] == '23')	{	$post['city'] = 'ELAZIG';		}
			else if($post['city'] == '24')	{	$post['city'] = 'ERZINCAN';		}
			else if($post['city'] == '25')	{	$post['city'] = 'ERZURUM';		}
			else if($post['city'] == '26')	{	$post['city'] = 'ESKISEHIR';	}
			else if($post['city'] == '27')	{	$post['city'] = 'GAZIANTEP';	}
			else if($post['city'] == '28')	{	$post['city'] = 'GIRESUN';		}
			else if($post['city'] == '29')	{	$post['city'] = 'GUMUSHANE';	}
			else if($post['city'] == '30')	{	$post['city'] = 'HAKKARI';		}
			else if($post['city'] == '31')	{	$post['city'] = 'HATAY';		}
			else if($post['city'] == '32')	{	$post['city'] = 'ISPARTA';		}
			else if($post['city'] == '33')	{	$post['city'] = 'MERSİN';		}
			else if($post['city'] == '34')	{	$post['city'] = 'ISTANBUL';		}
			else if($post['city'] == '35')	{	$post['city'] = 'IZMIR';		}
			else if($post['city'] == '36')	{	$post['city'] = 'KARS';			}
			else if($post['city'] == '37')	{	$post['city'] = 'KASTAMONU';	}
			else if($post['city'] == '38')	{	$post['city'] = 'KAYSERI';		}
			else if($post['city'] == '39')	{	$post['city'] = 'KIRKLALERI';	}
			else if($post['city'] == '40')	{	$post['city'] = 'KIRSEHIR';		}
			else if($post['city'] == '41')	{	$post['city'] = 'KOCAELI';		}
			else if($post['city'] == '42')	{	$post['city'] = 'KONYA';		}
			else if($post['city'] == '43')	{	$post['city'] = 'KÜTAHYA';		}
			else if($post['city'] == '44')	{	$post['city'] = 'MALATYA';		}
			else if($post['city'] == '45')	{	$post['city'] = 'MANISA';		}
			else if($post['city'] == '46')	{	$post['city'] = 'KAHRAMANMARAS';}
			else if($post['city'] == '47')	{	$post['city'] = 'MARDIN';		}
			else if($post['city'] == '48')	{	$post['city'] = 'MUGLA';			}
			else if($post['city'] == '49')	{	$post['city'] = 'MUŞ';			}
			else if($post['city'] == '50')	{	$post['city'] = 'NEVSEHIR';		}
			else if($post['city'] == '51')	{	$post['city'] = 'NİĞDE';			}
			else if($post['city'] == '52')	{	$post['city'] = 'ORDU';			}
			else if($post['city'] == '53')	{	$post['city'] = 'RİZE';			}
			else if($post['city'] == '54')	{	$post['city'] = 'SAKARYA';		}
			else if($post['city'] == '55')	{	$post['city'] = 'SAMSUN';		}
			else if($post['city'] == '56')	{	$post['city'] = 'SIIRT';		}
			else if($post['city'] == '57')	{	$post['city'] = 'SINOP';		}
			else if($post['city'] == '58')	{	$post['city'] = 'SIVAS';		}
			else if($post['city'] == '59')	{	$post['city'] = 'TEKIRDAG';		}
			else if($post['city'] == '60')	{	$post['city'] = 'TOKAT';		}
			else if($post['city'] == '61')	{	$post['city'] = 'TRABZON';		}
			else if($post['city'] == '62')	{	$post['city'] = 'TUNCELI';		}
			else if($post['city'] == '63')	{	$post['city'] = 'SANLIURFA';	}
			else if($post['city'] == '64')	{	$post['city'] = 'USAK';			}
			else if($post['city'] == '65')	{	$post['city'] = 'VAN';			}
			else if($post['city'] == '66')	{	$post['city'] = 'YOZGAT';		}
			else if($post['city'] == '67')	{	$post['city'] = 'ZONGULDAK';	}
			else if($post['city'] == '68')	{	$post['city'] = 'AKSARAY';		}
			else if($post['city'] == '69')	{	$post['city'] = 'BAYBURT';		}
			else if($post['city'] == '70')	{	$post['city'] = 'KARAMAN';		}
			else if($post['city'] == '71')	{	$post['city'] = 'KIRIKKALE';	}
			else if($post['city'] == '72')	{	$post['city'] = 'BATMAN';		}
			else if($post['city'] == '73')	{	$post['city'] = 'SIRNAK';		}
			else if($post['city'] == '74')	{	$post['city'] = 'BARTIN';		}
			else if($post['city'] == '75')	{	$post['city'] = 'ARDIHAN';		}
			else if($post['city'] == '76')	{	$post['city'] = 'IGDIR';		}
			else if($post['city'] == '77')	{	$post['city'] = 'YALOVA';		}
			else if($post['city'] == '78')	{	$post['city'] = 'KARABUK';		}
			else if($post['city'] == '79')	{	$post['city'] = 'KILIS';		}
			else if($post['city'] == '80')	{	$post['city'] = 'OSMANIYE';		}
			else if($post['city'] == '81')	{	$post['city'] = 'DÜZCE';		}
			
			
			if(isset($_POST['check_code_active']) or $post['code'] == '') 
			{ 
				$post['code'] = karekterTemizle($post['name']);
			}
			else
			{
				$post['code'] = karekterTemizle($post['code']);	
			}
			
			$data['customer_id'] = 0;
			$data['customer_id'] = $this->customer_model->add_customer($post);
			
			// eğer kredi kartı var ise kart bilgilerini güncelle
			if(@strlen($_POST['cc_no']) > 0)
			{
				$this->db->where('id', $data['customer_id']);
				$this->db->update('customers', array('cc_name'=>$_POST['cc_name'], 'cc_no'=>$_POST['cc_no'], 'cc_date_month'=>$_POST['cc_date_month'], 'cc_date_year'=>$_POST['cc_date_year'], 'cc_cvc'=>$_POST['cc_cvc']));
			}
			
			
			
			/* YENI SIPARIS FISI OLUSTURME 
				eger cari kart olusturma islemi basarili ise burasi calisacaktir
			*/
			$data['fiche_id'] = 0;
			if($data['customer_id'] > 0)
			{
				$post['customer_id'] 	= $data['customer_id'];
				$post['date']		 	= get_date();
				$post['note']		 	= '';
				$post['type']		 	= '0';
				$post['tax_status'] 	= 0;
				
				$data['fiche_id'] 		= $this->fiche_model->add_order($post);	
				
				if(!isset($_POST['referer']))
				{
					$_POST['referer'] = '';	
				}
				
				$this->db->where('id', $data['fiche_id']);
				$this->db->update('fiches', array('payment_type'=>$_POST['payment_type'], 'ship_type'=>$_POST['ship_type'], 'ip'=>$_POST['ip'], 'referer'=>$_POST['referer']));
				
				$this->db->from('fiches');
				$this->db->where('id', $data['fiche_id']);
				$data['fiche'] = $this->db->get()->row_array();
				$fiche = $data['fiche'];
				
				$this->fiche_model->add_order_meta($data['fiche']['id'], 'ip', $_POST['ip']);
				
				$installment = $this->input->post('installment');
				$this->fiche_model->add_order_meta($data['fiche']['id'], 'installment', $installment);
			}
			
			
			
			/* YENI FIS URUN EKLEME 
				eger yeni fis olusturma islemi basarili ise burasi calisacaktir
			*/
			if($data['fiche_id'] > 0)
			{
				$product_id	= $this->input->post('product_id');
				
				// ürün kodunun veritabanında olup olmadığını kontrol edelim
				$this->db->from('products');
				$this->db->where('id', $product_id);
				$this->db->where('status', '0');
				$query = $this->db->get()->result_array();
				if($query)
				{
					// Ürün kartı ek bilgiler	
					$product = $query[0];
					$insert_data['product_id']		= $product['id'];
					$insert_data['purchase_price']	= $product['purchase_price'];
					$insert_data['sale_price'] 		= $product['sale_price'];
					
					// order_view sayfası için değer ata
					$data['product']['name'] = $product['name'];
					
					
					// ürün fiyatı
					$price 	= $insert_data['sale_price'];
					$amount = $this->input->post('product_amount');
					
					if($amount > 1)
					{
						$price = $this->input->post('product_price');
					}
					
					
					// kdv oranları hesaplanıyor
					$insert_data['total']	= $amount * $price;
					if($data['fiche']['tax_status'] == '0') :
						$insert_data['tax']			= ($insert_data['total'] / 100) * $product['tax_rate'];
						$insert_data['tax_rate']	= $product['tax_rate'];
					else :
						$insert_data['tax']			= 0.00;
						$insert_data['tax_rate']	= 0.00;
					endif;
					$insert_data['grand_total'] = $insert_data['total'] + $insert_data['tax'];
					
					
					$insert_data['type']		= $data['fiche']['type'];
					$insert_data['price'] 		= $price;
					$insert_data['amount']		= $amount;
					$insert_data['fiche_id'] 	= $data['fiche']['id']; 
					$insert_data['customer_id']	= $data['fiche']['customer_id'];
					$insert_data['user_id']		= get_c_user('user_id');
					
					// ürün ekleme işlemni model dosyasına gönder
					$order_item_id = $this->fiche_model->add_order_item($insert_data);
					
					
					// eğer fişe ürün ekleme başarılı ise
					if($order_item_id > 0)
					{	
						check_product_card($insert_data['product_id']);
						
						check_order($data['fiche_id']); // fiş bakiyesini derle
						check_customer_card($data['fiche']['customer_id']); // cari bakiyesini derle
								
						$data['success'] = true;
						
						// personel primlerini etkilensin diye item_user datasına ekleme yapılıyor
						$this->db->insert('fiche_item_user', array(
						'date'			=> get_date(),
						'fiche_id'		=> $fiche['id'],
						'item_id'		=> $order_item_id,
						'product_id'	=> $product['id'],
						'customer_id'	=> $insert_data['customer_id'],
						'amount'		=> $insert_data['amount']		
						));
						
						$this->load->view('order/order_view_null', $data);
					}
					else // eğer fişe ürün ekleme başarısız ise
					{
						$data['alert_box']['type']	= 'alert';
						$data['alert_box']['text']	= 'Ürün eklenirken bilinmeyen bir hata meydana geldi.';
						
						$this->load->view('order/order_view', $data);
					}
				}
				else // eğer ürün kodu veritabanında bulunmadıysa
				{
					$data['alert_box']['type']	= 'alert';
					$data['alert_box']['text']	= 'Ürün ID veritabanında bulunamadı.';	
					
					$this->load->view('order/order_view', $data);
				}
			}
			
		}
		
		
	}
	
	
	function yk_xml()
	{
		$this->load->view('order/yk_xml_view');
	}
	
	
	function yk_ship()
	{
		
		
		if($_GET['ship'] == 1)
		{
			
			foreach($_POST['fiche_id'] as $fiche_id):
			
				$this->db->where('id', $fiche_id);
				$this->db->update('fiches', array('ship'=>$_GET['ship'], 'date_ship'=>get_date()));	
			
				add_log(array(
					'type'			=> 'KARGO',
					'fiche_id'		=> $fiche_id,
					'text'			=> 'KARGO DURUMU : VERILDI.'
				));
			endforeach;
		}
		else
		{
			foreach($_POST['fiche_id'] as $fiche_id):
			
				$this->db->where('id', $fiche_id);
				$this->db->update('fiches', array('ship'=>$_GET['ship'], 'date_ship'=>get_date()));	
				
				add_log(array(
					'type'			=> 'KARGO',
					'fiche_id'		=> $fiche_id,
					'text'			=> 'KARGO DURUMU : VERILMEDI.'
				));
			endforeach;
		}
	}
	
	
	function print_invoice($fiche_id)
	{
		$data['fiche'] = $this->fiche_model->get_order($fiche_id);
		$this->load->view('order/print', $data);
	}
	
	function print_ptt_fiche($fiche_id)
	{
		$data['fiche'] = $this->fiche_model->get_order($fiche_id);
		$this->load->view('order/print_ptt_fiche', $data);
	}
	
	// biz sizi arayalim
	function add_biz_sizi_arayalim()
	{
		$name_surname 	= $_POST['name_surname'];
		$phone			= $_POST['phone'];
		$product_id			= $_POST['product_id'];
		
		$this->db->insert('we_call_the', array('date'=>get_date(), 'name'=>$name_surname, 'phone'=>$phone, 'product_id'=>$product_id));
	}
	
	
	
}

