<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Payment extends CI_Controller 
{

	public function index()
	{
		
	}
	
	
	
	/*
		ADD ORDER
		@author: mustafa tanriverdi
		@description:
			* bu fonksiyon yeni bir tane ödeme fişi oluşturur
	*/
	public function add_payment()
	{
		$data['page_access'] = check_user_role('payment/add_payment');
		
		if(isset($_POST['btn_add_payment']))
		{
			$this->form_validation->set_rules('date', 'Tarih', 'trim|required|min_length[10]|max_length[10]');
			$this->form_validation->set_rules('customer_id', 'Cari Kart', 'trim|required||integer|max_length[11]');		
			$this->form_validation->set_rules('payment_total', 'Ödeme Tutarı', 'trim|required|numeric|min_length[1]|max_length[11]');
			
			if($this->form_validation->run() == true)
			{
				$post['date']			= $this->input->post('date');
				$post['note']			= $this->input->post('note');
				$post['customer_id']	= $this->input->post('customer_id');
				$post['type']			= $this->input->post('type');
				$post['grand_total']	= $this->input->post('payment_total');
				
				$post['leaf'] = 'pay';
				$payment_id = $this->payment_model->add_payment($post);
				
				
				if($payment_id > 0)
				{
					// log
					if( $post['type'] == 0 ){ $log_text = 'Ödeme alındı.'; } else { $log_text = 'Ödeme verildi.'; }
					add_log(array(
						'type'			=> 'ödeme',
						'customer_id'	=> $post['customer_id'],
						'fiche_id'		=> $payment_id,
						'text'			=> $log_text
						));
					
					$this->fiche_model->add_order_meta($payment_id, 'note', $post['note']);
					
					// message	
					$data['alert_box']['type']	= 'success';
					$data['alert_box']['text']	= 'Ödeme işlemi başarılı.';
				}
				else
				{
					$data['alert_box']['type']	= 'alert';
					$data['alert_box']['text']	= 'Bilinmeyen bir hata oluştu.';
				}
				
				check_customer_card($post['customer_id']); // cari bakiyesini derle
			}
		}
		
		
		
		$data['customers'] = $this->customer_model->get_customer_list();
		
		$this->template->view('payment/add_payment_view', $data);
	}
	
	
	
	/*
		PAYMENT PAGE
		@author: mustafa tanriverdi
		@description:
			* bu fonksiyon kayıtlı ödeme formunu oluşturur
	*/
	function the_payment($fiche_id)
	{
		$data['page_access'] = check_user_role('payment/the_payment');
		
		$data['fiche'] = $this->fiche_model->get_order($fiche_id);
		
		if(isset($_POST['btn_payment_delete']))
		{
			$this->db->where('id', $fiche_id);
			$this->db->update('fiches', array('status'=>'1'));
			
			
			add_log(array(
						'type'			=> 'ödeme sil',
						'customer_id'	=> $data['fiche']['customer_id'],
						'fiche_id'		=> $fiche_id,
						'text'			=> 'Ödeme işlemi silindi.'
						));
			
			check_customer_card($data['fiche']['customer_id']); // cari bakiyesini derle
			
			// message	
			$data['alert_box']['type']	= '';
			$data['alert_box']['text']	= 'Ödeme işlemi silindi.';
		}
		
		$this->template->view('payment/payment_view', $data);
	}
	
	
	
	
	
	/*
		PAYMENT LIST
		@author: mustafa tanrıverdi
		@description:
			* bu fonksiyon kayıtlı fişleri listeler
	*/
	function get_fiche_list()
	{
		$where['page_access'] = check_user_role('payment/get_fiche_list');	
		
		$where['where'] = array('status'=>'0', 'leaf'=>'pay');
		$where['order_by'] = 'id'; $where['order_by_value']='DESC';
		$where['title'] = 'ÖDEME FİŞLERİ';
		$this->template->view('fiche/_fiche_list_view', $where);
	}
	
	
	
	
}

