<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Product extends CI_Controller 
{

	public function index()
	{
		
	}
	
	
	
	/*
		YENI PRODUCT CARD
		@author: mustafa tanriverdi
		@description:
			* bu fonksiyon yeni bir tane stok kartı oluşturur
	*/
	public function add_product()
	{
		$data['page_access'] = check_user_role('product/add_product');
		$continue = true;
		
		if(isset($_POST['btn_add_product']) and check_refresh())
		{
			$this->form_validation->set_rules('name', 'Stok Adı', 'trim|required|min_length[3]|min_lenght[32]');
			$this->form_validation->set_rules('purchase_price', 'Satın Alma Fiyatı', 'trim|numeric');	
			$this->form_validation->set_rules('sale_price', 'Satış Fiyatı', 'trim|numeric');
			$this->form_validation->set_rules('tax_rate', 'Kdv Oranı', 'trim|digits|max_length[3]');	
			
			if($this->form_validation->run() == true)
			{
				$post['code']	= $this->input->post('code');
				$post['name']	= $this->input->post('name');
				$post['purchase_price']	= $this->input->post('purchase_price');
				$post['sale_price']		= $this->input->post('sale_price');
				$post['tax_rate']		= $this->input->post('tax_rate');
				
				
				// eğer check seçilmemeiş ve code kutusu boş ise
				if(isset($_POST['check_code_active']) or $post['code'] == '') 
				{ 
					function temizle($tr1) 
					{
						$turkce=array("ş","Ş","ı","ü","Ü","ö","Ö","ç","Ç","ş","Ş","ı","ğ","Ğ","İ","ö","Ö","Ç","ç","ü","Ü");
						$duzgun=array("s","S","i","u","U","o","O","c","C","s","S","i","g","G","I","o","O","C","c","u","U");
						$tr1=str_replace($turkce,$duzgun,$tr1);
						$tr1 = preg_replace("@[^a-z0-9\-_şıüğçİŞĞÜÇ]+@i","-",$tr1);
						return $tr1;
					}

					$post['code'] = temizle($post['name']);
					
					
					// stok kodununun veritabanında var olup olmadığını kontrol et
					$i = 0; $post['_code'] = $post['code'];
					while(10000 > $i) 
					{ 
						if($this->product_model->get_product('', array('code'=>$post['_code'])))
							{ $post['_code'] = $post['code'].'_'.$i; } 
						else 
							{ $i = 10001; } $i++;
					} 
					if($post['code'] != $post['_code']) { $post['code'] = $post['_code'];	 }
				}
				else // eğer stok kodu menuel girilmiş ise
				{ 
					// stok kodunun veritabanında var olup olmadığını kontrol et
					if($this->product_model->get_product('', array('code'=>$post['code'], 'status'=>'0')))
					{
						$data['alert_box']['type']	= 'alert';
						$data['alert_box']['text']	= 'Stok kodu veritabanında bulundu.';
						$continue = false;
					}
				}
				
				
				// eğer tüm işlemler doğru ise stok kartını oluştur
				if($continue == true) 
				{ 
					$product_id = $this->product_model->add_product($post);
					
					if($product_id > 0)
					{
						$data['alert_box']['type']	= 'success';
						$data['alert_box']['text']	= 'Stok kartı oluşturuldu.';
						
						add_log(array(
								'type'			=> 'güncelleme',
								'product_id'	=> $product_id ,
								'text'			=> 'Stok kartı oluşturuldu.'
								));
					}
				}
				
				
			}
		}
		
		$this->template->view('product/add_product_view', $data);
	}
	
	
	
	
	/*
		PRODUCT LIST
		@author: mustafa tanriverdi
		@description:
			* bu fonksiyon kayıtlı ürünleri döndürür
	*/
	function list_product()
	{
		$data['page_access'] = check_user_role('product/list_product');
		
		$data['products'] = $this->product_model->get_list_product();
		
		$this->template->view('product/list_product_view', $data);
	}
	
	
	
	
	/*
		THE PRODUCT
		@author: mustafa tanriverdi
		@description: 
			* bu fonksiyon ürün bilgisini döndürür
	*/
	function the_product($product_id)
	{
		$data['page_access'] = check_user_role('product/the_product');
		$continue = true;
		
		if(isset($_POST['btn_update_product']) and check_refresh())
		{
			$this->form_validation->set_rules('name', 'Stok Adı', 'trim|required|min_length[3]|min_lenght[32]');
			$this->form_validation->set_rules('purchase_price', 'Satın Alma Fiyatı', 'trim|numeric');	
			$this->form_validation->set_rules('sale_price', 'Satış Fiyatı', 'trim|numeric');
			
			if($this->form_validation->run() == true)
			{
				$post['code']	= $this->input->post('code');
				$post['name']	= $this->input->post('name');
				$post['purchase_price']	= $this->input->post('purchase_price');
				$post['sale_price']		= $this->input->post('sale_price');
				$post['tax_rate']		= $this->input->post('tax_rate');
				
				
				// eğer check seçilmemeiş ve code kutusu boş ise
				if(isset($_POST['check_code_active']) and $post['code'] == '' or $post['code'] =='') 
				{ 
					$post['code'] = karekterTemizle($post['name']);
					
					// stok kodununun veritabanında var olup olmadığını kontrol et
					$i = 0; $post['_code'] = $post['code'];
					while(10000 > $i) 
					{ 
						$this->db->from('products');
				 		$this->db->where('code', $post['_code']); 
						$this->db->where_not_in('id', $product_id); 
						$product_code = $this->db->get()->result_array();
						
						if($product_code)
							{ $post['_code'] = $post['code'].'_'.$i; } 
						else 
							{ $i = 10001; } $i++;
					} 
					if($post['code'] != $post['_code']) { $post['code'] = $post['_code'];	 }
				}
				else // eğer stok kodu menuel girilmiş ise
				{ 
					$post['code'] = karekterTemizle($post['code']);
					
					// stok kodunun veritabanında var olup olmadığını kontrol et
					$this->db->from('products');
					$this->db->where('status', 0);
					$this->db->where('code', $post['code']); 
					$this->db->where_not_in('id', $product_id); 
					$product_code = $this->db->get()->result_array();
					if($product_code)
					{
						$data['alert_box']['type']	= 'alert';
						$data['alert_box']['text']	= 'Stok kodu veritabanında bulundu.';
						$continue = false;
					}
				}
				
				
				// eğer tüm işlemler doğru ise stok kartını güncelle
				if($continue == true) 
				{ 
					$post['product_id'] = $product_id;
					$update = $this->product_model->update_product($post);
					
					if($update)
					{
						$data['alert_box']['type']	= 'success';
						$data['alert_box']['text']	= 'Stok kartı güncellendi.';
						
						add_log(array(
								'type'			=> 'güncelleme',
								'product_id'	=> $product_id ,
								'text'			=> 'Stok kartı güncellendi.'
								));
					}
				}
				
				
			}
		}
		
		if(isset($_POST['btn_delete']))
		{
			$this->product_model->delete_product($product_id);
			
			add_log(array(
								'type'			=> 'silme',
								'product_id'	=> $product_id ,
								'text'			=> 'Stok kartı silindi.'
								));	
		}
		if(isset($_POST['btn_active']))
		{
			$this->product_model->active_product($product_id);	
			
			add_log(array(
								'type'			=> 'aktif',
								'product_id'	=> $product_id ,
								'text'			=> 'Stok kartı aktif edildi.'
								));
		}
		
		$data['product'] = $this->product_model->get_product($product_id, '');
		$this->template->view('product/product_view', $data);	
	}
	
	
	
	
}

